# 画面設計書 53-kubeadm version

## 概要

本ドキュメントは、kubeadmツールの `kubeadm version` コマンドに関する画面設計書である。kubeadmのバージョン情報を表示するシンプルなコマンドで、複数の出力形式に対応する。

### 本画面の処理概要

`kubeadm version` コマンドは、kubeadmバイナリ自体のバージョン情報を出力するCLIコマンドである。Kubernetesのコンポーネントバージョン管理体系に基づく詳細なバージョン情報を提供する。

**業務上の目的・背景**：Kubernetesクラスターの運用において、使用しているツールのバージョンを正確に把握することは極めて重要である。特にクラスターのアップグレード作業では、kubeadmのバージョンがアップグレード先のKubernetesバージョンと一致していることを確認する必要がある。また、トラブルシューティングや問題報告の際にもバージョン情報は基本的な診断情報として必要となる。本コマンドは、これらの場面でkubeadmのバージョンを迅速に確認できるようにする。

**画面へのアクセス方法**：ターミナル上で `kubeadm version` コマンドを実行する。特別な権限は不要で、kubeadmバイナリが利用可能であれば誰でも実行できる。

**主要な操作・処理内容**：
1. `kubeadm version` でデフォルト形式（Go構造体表現）のバージョン情報を出力
2. `kubeadm version -o short` でGitVersionのみを簡潔に出力
3. `kubeadm version -o yaml` でYAML形式のバージョン情報を出力
4. `kubeadm version -o json` でJSON形式のバージョン情報を出力

**画面遷移**：本コマンドは単独実行のコマンドであり、他のコマンドへの遷移はない。`kubeadm upgrade` の事前確認として使用されることが多い。

**権限による表示制御**：特になし。権限に依存しない情報表示のみのコマンド。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 118 | クラスター初期化（init） | 補助機能 | kubeadmのバージョン情報を出力する |

## 画面種別

CLIコマンド（バージョン情報表示）

## URL/ルーティング

```
kubeadm version [flags]
```

## 入出力項目

| 項目名 | 入出力 | 必須 | 型 | デフォルト値 | 説明 |
|--------|--------|------|-----|-------------|------|
| -o / --output | 入力 | 任意 | string | "" | 出力フォーマット。`yaml`, `json`, `short` が指定可能。未指定時はGo構造体表現 |
| バージョン情報 | 出力 | - | text/yaml/json | - | kubeadmのバージョン情報 |

## 表示項目

### デフォルト出力（Go構造体表現）

| 項目名 | 説明 |
|--------|------|
| Major | メジャーバージョン |
| Minor | マイナーバージョン |
| GitVersion | 完全なGitバージョン文字列（例: v1.32.0） |
| GitCommit | ビルド元のGitコミットハッシュ |
| GitTreeState | Gitツリーの状態（clean/dirty） |
| BuildDate | ビルド日時 |
| GoVersion | 使用されたGoのバージョン |
| Compiler | コンパイラ情報 |
| Platform | ビルドプラットフォーム（OS/アーキテクチャ） |

### YAML出力

```yaml
clientVersion:
  major: "1"
  minor: "32"
  gitVersion: "v1.32.0"
  gitCommit: "..."
  gitTreeState: "clean"
  buildDate: "..."
  goVersion: "go1.x.x"
  compiler: "gc"
  platform: "linux/amd64"
```

### JSON出力

```json
{
  "clientVersion": {
    "major": "1",
    "minor": "32",
    "gitVersion": "v1.32.0",
    ...
  }
}
```

### Short出力

GitVersion文字列のみ（例: `v1.32.0`）

## イベント仕様

### 1-kubeadm version 実行

コマンド実行時の処理フローは以下の通り。

1. `version.Get()` でコンパイル時に埋め込まれたバージョン情報を取得（`component-base/version` パッケージ）
2. `Version` 構造体に `ClientVersion` としてバージョン情報を設定
3. `--output` フラグの値に応じて出力フォーマットを選択:
   - 未指定（空文字列）: `fmt.Fprintf` でGo構造体の `%#v` フォーマットで出力
   - `short`: `GitVersion` フィールドのみを出力
   - `yaml`: `sigs.k8s.io/yaml` パッケージでYAMLにマーシャルして出力
   - `json`: `encoding/json` パッケージでJSON（インデント付き）にマーシャルして出力
   - その他: `invalid output format` エラーを返却

## データベース更新仕様

### 操作別データベース影響一覧

本コマンドはデータの読み書きを一切行わない。バイナリに埋め込まれたバージョン情報の表示のみ。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| version実行 | なし | なし | ローカルのバージョン情報表示のみ |

## メッセージ仕様

| 種別 | メッセージ | 条件 |
|------|----------|------|
| 情報 | `kubeadm version: &version.Info{Major:"...", Minor:"...", ...}` | デフォルト出力時 |
| エラー | `invalid output format: %s` | 未サポートの出力フォーマットが指定された場合 |
| エラー | `error accessing flag %s for command %s` | フラグアクセスエラー時 |

## 例外処理

| 例外状況 | 処理内容 |
|---------|---------|
| 不正な出力フォーマット指定 | `invalid output format: <指定値>` エラーを返却 |
| YAMLマーシャルエラー | マーシャル処理のエラーをそのまま返却 |
| JSONマーシャルエラー | マーシャル処理のエラーをそのまま返却 |
| 引数が指定された場合 | `cobra.NoArgs` 制約により、位置引数を受け取るとエラー |

## 備考

- 本コマンドはAPI Serverやクラスターへの接続を一切行わない。クラスターに接続せずにローカルで実行可能
- `kubectl version` とは異なり、サーバーサイドのバージョン情報は取得しない（クライアントバージョンのみ）
- バージョン情報はビルド時に `ldflags` でバイナリに埋め込まれる
- `Version` 構造体は `ClientVersion` フィールドのみを持つ（サーバーバージョンは含まない）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

バージョン情報を保持する構造体を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | version.go | `cmd/kubeadm/app/cmd/version.go` | `Version` 構造体（35-37行目）: `ClientVersion` フィールドに `apimachineryversion.Info` へのポインタを保持 |
| 1-2 | info.go | `staging/src/k8s.io/apimachinery/pkg/version/info.go` | `Info` 構造体: Major, Minor, GitVersion, GitCommit, GitTreeState, BuildDate, GoVersion, Compiler, Platform フィールドを持つ |

**読解のコツ**: `version.Info` はKubernetes全コンポーネントで共通のバージョン情報構造体である。

#### Step 2: エントリーポイントを理解する

コマンドの定義と実行関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | version.go | `cmd/kubeadm/app/cmd/version.go` | `newCmdVersion()` 関数（40-51行目）: コマンド定義。`--output` フラグの追加。RunEから `RunVersion()` を呼び出す |
| 2-2 | version.go | `cmd/kubeadm/app/cmd/version.go` | `RunVersion()` 関数（55-90行目）: メインロジック。バージョン情報取得と出力フォーマット分岐 |

**主要処理フロー**:
1. **57行目**: `version.Get()` でバージョン情報を取得
2. **58-60行目**: `Version` 構造体にセット
3. **62-66行目**: `--output` フラグの値を取得
4. **68-87行目**: フォーマットに応じた出力分岐（switch文）

#### Step 3: バージョン情報の取得元を理解する

ビルド時に埋め込まれるバージョン情報の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | version.go | `staging/src/k8s.io/component-base/version/version.go` | `Get()` 関数: ビルド時に `ldflags` で設定された変数からバージョン情報を構築して返す |

### プログラム呼び出し階層図

```
kubeadm version
    |
    +-- newCmdVersion() [cmd/kubeadm/app/cmd/version.go:40]
            |
            +-- RunVersion() [cmd/kubeadm/app/cmd/version.go:55]
                    |
                    +-- version.Get() [component-base/version]
                    |       |
                    |       +-- (ビルド時埋め込みの変数から Info 構造体を構築)
                    |
                    +-- (switch: output format)
                            |
                            +-- "" : fmt.Fprintf(out, "%#v", v.ClientVersion)
                            +-- "short" : fmt.Fprintf(out, "%s", GitVersion)
                            +-- "yaml" : yaml.Marshal(&v)
                            +-- "json" : json.MarshalIndent(&v, "", "  ")
                            +-- default : error("invalid output format")
```

### データフロー図

```
[入力]                  [処理]                          [出力]

                    +-- RunVersion() --------+
-o / --output ─────>|                        |
                    | version.Get()          |
                    |   |                    |
                    |   v                    |
                    | Version{ClientVersion} |
                    |   |                    |
                    |   v                    |
                    | format switch          |
                    |   |                    |
                    +---|--------------------+
                        |
                        +--("") ──────> Go構造体表現 ──> stdout
                        +--("short") ─> GitVersion ───> stdout
                        +--("yaml") ──> YAML ─────────> stdout
                        +--("json") ──> JSON ─────────> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| version.go | `cmd/kubeadm/app/cmd/version.go` | ソース | コマンド定義・メインロジック |
| version.go | `staging/src/k8s.io/component-base/version/version.go` | ソース | バージョン情報の取得（ビルド時埋め込み変数の読み取り） |
| info.go | `staging/src/k8s.io/apimachinery/pkg/version/info.go` | ソース | `Info` 構造体の定義（バージョン情報のデータ構造） |
| errors.go | `cmd/kubeadm/app/util/errors/` | ソース | エラーラッピングユーティリティ |
